#!/bin/sh

# AVR GNU development tools build and install AVR tool chain.

# Run the script as is to get a list of the files necessary to build,
# takes optionally three arguments, the location of the source files,
# where to install and build the tools and the path where to output a
# log file. See configuration section below, that will require
# modification for different compiler/avr-libc versions.

# Insight:6.8, Binutils:2.19, GCC:4.3.2, AVR-LibC:1.6.4 are
# the current versions.

# Source files will be downloaded, WinAVR patch set applied,
# code will then be compiled and installed.

# This Script is based on the script from Rod Moffitt at
# http://www.rod.info, and the "Bing" script at
# http://www.avrfreaks.net/ .

#########################################################################
# $Id: buildavr.sh,v 1.29 2007/02/02 04:20:09 rmoffitt Exp $

# Copyright (C) 2003-2005 Rod Moffitt rod@rod.info http://rod.info
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#########################################################################

# Start of configuration: Edit these defaults to suit your environment, or
# simply override them via the command line - you will need write
# permission to $prefix (make sure it is empty or non-existent).

# Location of source tarballs, must be an absolute page (ie. starts
# with / or ~):
archive=~/AVR/archives

# Location of WinAVR patch set, must be an absolute page (ie. starts
# with / or ~):
patches=~/AVR/patches

# AVR GNU tools will be installed under this directory:
prefix=~/AVR/GCC

# Build log file - see this if any errors occur:
buildlog=/tmp/buildavr.log

# end of configuration

#########################################################################

# What are we building for?:
target=avr

# The version numbers below need changed for each new release:

binutilsver=2.19
binutilsbase=binutils-${binutilsver}
binutilstar=${binutilsbase}.tar.bz2
#sourcefiles="${sourcefiles} ${binutilstar} binutils-avr-new-devs.diff"
sourcefiles="${sourcefiles} ${binutilstar}"

gccver=4.3.2
gcc=gcc-${gccver}
gcctar=${gcc}.tar.bz2
gccbase=gcc-${gccver}
#sourcefiles="${sourcefiles} ${gcctar} gcc-3_4_0-avr-new-devs.patch"
sourcefiles="${sourcefiles} ${gcctar}"

avrlibcver=1.6.4
avrlibcbase=avr-libc-${avrlibcver}
avrlibctar=${avrlibcbase}.tar.bz2
sourcefiles="${sourcefiles} ${avrlibctar}"

insightver=6.8
insightbase=insight-${insightver}
insighttar=${insightbase}.tar.bz2
#sourcefiles="${insighttar}"

#########################################################################

# Nothing from here down should require configuration.

#########################################################################

build_binutils()
{
   if [ ! -d ${binutilsbase} ];
   then

    echo "($0) installing binutils source"
    ls $archive/${binutilstar}
    tar xvjf $archive/${binutilstar}
    cerror "binutils source installation failed"

    cd ${binutilsbase}

    echo "($0) Patching binutils source with the following patches:"
    for file in $(ls $patches/binutils/${binutilsver}/*.patch|sort); do
     name=`basename $file .patch`
     echo $file $name

     patch -p0 < $patches/binutils/${binutilsver}/$name.patch
     cerror "binutils patching failed"

    done

   mkdir -p ../../build/${binutilsbase}
   fi

   cd  ${binutilsbase}/../../build/${binutilsbase}

   echo "($0) configuring binutils source"
   ../../source/${binutilsbase}/configure --target=${target} \
      --prefix=$prefix --disable-nls --quiet
   cerror "binutils configuration failed"

   echo "($0) building binutils"

   make maybe-configure-bfd
   cerror "binutils build failed"

   pushd bfd
   make headers
   cerror "binutils build failed"
   popd

   make all install clean
   cerror "binutils build failed"
}

build_gcc()
{
   if [ ! -d ${gccbase} ];
   then

    echo "($0) installing GCC source"
    echo $archive/${gcctar}
    tar xvjf $archive/${gcctar}
    cerror "GCC source installation failed"

    cd ${gccbase}

    echo "($0) patching GCC source"
    for file in $(ls $patches/gcc/${gccver}/*.patch|sort); do
     name=`basename $file .patch`
     echo $file $name

     patch -p0 < $patches/gcc/${gccver}/$name.patch
     cerror "gcc patching failed"

    done

    mkdir -p ../../build/${gcc}
   fi

   cd  ${gccbase}../../build/${gcc}

   echo "($0) configuring GCC source"
   ../../source/${gccbase}/configure --target=${target} --disable-nls \
      --prefix=$prefix --enable-languages="c,c++" --disable-libssp --with-dwarf2 --quiet
   cerror "GCC configuration failed"

   echo "($0) building GCC"
   make all install clean
   cerror "GCC build failed"
}

build_libc()
{
# Version=`autoconf --version | head -n 1 | sed -n -e 's/^.*\([0-9]\.[0-9]*\).*$/\1/p'`
#and than do a simple string compare:
# if [ $Version \< "2.59" ]

   if [ ! -d ${gcclibcbase} ];
   then

    echo "($0) installing libc"
    tar xvjf $archive/${avrlibctar}
    cerror "libc source installation failed"

    cd $prefix/$avrlibcbase

    echo "($0) patching avr-libc source"
    for file in $(ls $patches/avr-libc/${avrlibcver}/*.patch|sort); do
     name=`basename $file .patch`
     echo $file $name

     patch -p0 < $patches/avr-libc/${avrlibcver}/$name.patch
     cerror "avr-libc patching failed"

    done

   echo "($0) bootstraping libc source"
   $prefix/$avrlibcbase/bootstrap
   cerror "libc bootstrap failed"

   mkdir -p $prefix/build/${avrlibcbase}
  fi

   cd $prefix/build/${avrlibcbase}

   echo "($0) configuring libc source"
   CC=$prefix/bin/avr-gcc ../../source/${avrlibcbase}/configure \
      --prefix=$prefix --build=`../../source/${avrlibcbase}/config.guess` --host=avr  --quiet
   cerror "libc configuration failed"

   echo "($0) building libc"
   make all install clean
   cerror "libc build failed"
}

build_install()
{
}

buildandinstall()
{
   mkdir -p $prefix/source $prefix/build

#   cd $prefix/source

#   echo "($0) installing insight source"
#   tar xvjf $archive/${insighttar}
#   cerror "insight source installation failed"
#
#   mkdir -p ../build/${insightbase}
#   cd ../build/${insightbase}
#
#   echo "($0) configuring insight source"
#   ../../source/${insightbase}/configure -v --target=${target} \
#      --prefix=$prefix --with-gnu-ld --with-gnu-as --quiet
#   cerror "insight configuration failed"
#
#   echo "($0) building insight"
#   make all install clean
#   cerror "insight build failed"

   cd $prefix/source

   build_binutils

   # path to the newly installed binutils is needed to build GCC
   PATH=$prefix/bin:$PATH

   cd $prefix/source

   build_gcc

   cd $prefix/source

   build_libc

   # strip all the binaries
   find $prefix -type d -name bin -exec find \{\} -type f \; | xargs strip > /dev/null 2>&1

   cecho "\n"
   cecho "${cyan}installation of ${target} GNU tools complete\n"
   cecho "${cyan}add ${GREEN}$prefix/bin${cyan} to your path to use the ${target} GNU tools\n"
   cecho "${cyan}you might want to run the following to save disk space:\n"
   cecho "\n"
   cecho "${green}rm -rf $prefix/source $prefix/build\n"
}

# color definitions
RED='\e[1;31m'
green='\e[0;32m'
GREEN='\e[1;32m'
cyan='\e[0;36m'
yellow='\e[0;33m'
NC='\e[0m' # no color

cecho()
{
   echo -ne "($green$0$NC) $1$NC"
}

cerror()
{
   if [ $? -ne 0 ];
   then
      cecho "$RED$1$NC\n"
      exit
   fi
}

ask()
{
   cecho "$@ [y/n] "
   read ans

   case "$ans" in
      y*|Y*) return 0 ;;
      *) return 1 ;;
   esac
}

# source command line overrides

until [ -z "$1" ];
do
   eval "$1"
   shift
done

cecho "${cyan}about to build and install ${target} GNU development tools using\n"
cecho "${cyan}the following settings (override via the command line):\n"
cecho "\n"
cecho "   ${yellow}archive=${archive} $cyan(location of source tarballs)\n"
cecho "   ${yellow}prefix=${prefix} $cyan(installation prefix/directory)\n"
cecho "   ${yellow}buildlog=${buildlog} $cyan(build log)\n"
cecho "\n"
ask "${cyan}proceed?";

if [ "$?" -eq 1 ]
then
   exit
fi

# check on target directory

if [ -d $prefix ];
then
   cecho "\n"
   ask "${RED}$prefix already exists, continue?";

   if [ "$?" -eq 1 ]
   then
      exit
   fi
fi

mkdir -p $prefix 2> /dev/null

if [ ! -w $prefix ];
then
   cecho "\n"
   cecho "${RED}failed! to create install directory $prefix\n";
   exit
fi

# check for required files

missingfiles=;

for file in $sourcefiles;
do
   if [ ! -f $archive/$file ];
   then
      missingfiles="${missingfiles} $file";
   fi
done

if [ -n "$missingfiles" ];
then
   cecho "\n"
   cecho "${RED}error! required source file(s):\n";
   cecho "\n"

   for file in $missingfiles;
   do
      cecho "   ${yellow}$file\n"
   done

   cecho "\n"
   cecho "${cyan}were missing - download them to $archive first\n";
   exit
fi

buildandinstall 2>&1 | tee $buildlog

exit
